<?php
/**
* @version		$Id: view.html.php 940 2008-04-01 18:42:17Z geraint $
* @package		Joomla
* @subpackage	Weblinks
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

JLoader::import( 'views.abstract.joomfishview',JPATH_COMPONENT_ADMINISTRATOR);
jimport( 'joomla.filesystem.file');
jimport( 'joomla.application.component.view');
jimport('joomla.html.pane');

/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
class LanguagesViewLanguages extends JoomfishAbstractView
{
	/**
	 * Control Panel display function
	 *
	 * @param template $tpl
	 */
	function display($tpl = null)
	{
		global $mainframe;
		
		$document =& JFactory::getDocument();
		// this already includes administrator
		$livesite = JURI::base();
		$document->addStyleSheet($livesite.'components/com_joomfish/assets/css/joomfish.css');

		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('Language Title'));
		
		// hide the sub menu
		JRequest::setVar('hidemainmenu',1);		
		
		// Set toolbar items for the page
		JToolBarHelper::title( JText::_( 'Language Title' ), 'language' );
		//JToolBarHelper::custom( 'languages.translateConfig', 'config', 'config', JText::_( 'Config' ),true);
		JToolBarHelper::deleteList('Are you sure you want to delete the selcted items?', 'language.remove');
		JToolBarHelper::custom( 'languages.save', 'save', 'save', JText::_( 'Save' ),false);
		JToolBarHelper::custom( 'languages.apply', 'apply', 'apply', JText::_( 'Apply' ),false);
		JToolBarHelper::cancel('languages.cancel');
		JToolBarHelper::help( 'screen.languages', true);

		$option				= JRequest::getCmd('option', 'com_joomfish');
		$filter_state		= $mainframe->getUserStateFromRequest( $option.'filter_state',		'filter_state',		'',				'word' );
		$filter_catid		= $mainframe->getUserStateFromRequest( $option.'filter_catid',		'filter_catid',		0,				'int' );
		$filter_order		= $mainframe->getUserStateFromRequest( $option.'filter_order',		'filter_order',		'l.ordering',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( $option.'filter_order_Dir',	'filter_order_Dir',	'',				'word' );
		$search				= $mainframe->getUserStateFromRequest( $option.'search',			'search',			'',				'string' );
		$search				= JString::strtolower( $search );
				
		$languages	= &$this->get('data');
		$defaultLanguage = &$this->get('defaultLanguage');
		
		$this->assignRef('items', $languages);
		$this->assignRef('defaultLanguage', $defaultLanguage);
		
		// state filter
		$lists['state']	= JHTML::_('grid.state',  $filter_state );

		// table ordering
		$lists['order_Dir'] = $filter_order_Dir;
		$lists['order'] = $filter_order;

		// search filter
		$lists['search']= $search;

		$this->assignRef('user',		JFactory::getUser());
		$this->assignRef('lists',		$lists);
		
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}

	/**
	 * Method displaying the config traslation layout
	 */
	function translateConfig($tpl = null) {

		$document =& JFactory::getDocument();
		// this already includes administrator
		$livesite = JURI::base();
		$document->addStyleSheet($livesite.'components/com_joomfish/assets/css/joomfish.css');

		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('Language Title'));
		
		// hide the sub menu
		JRequest::setVar('hidemainmenu',1);		
		
		// Set toolbar items for the page
		JToolBarHelper::title( JText::_('JOOMFISH_TITLE') .' :: '. JText::_( 'Translate Global Configuration' ), 'fish' );
		JToolBarHelper::save('languages.saveTranslateConfig');
		JToolBarHelper::cancel('languages.show');
		JToolBarHelper::help( 'screen.languages', true);

		parent::display($tpl);		
	}
	
}
?>