<?php
/**
* @version		$Id: joomfishview.php 943 2008-04-02 18:15:40Z geraint $
* @package		Joomla
* @subpackage	Weblinks
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view');
jimport('joomla.html.pane');

/**
 * Method to translate with a pre_reg function call
 *
 * @param array $matches
 * @return string
 */
function jfTranslate($matches){
	$translation = '!!!' .JText::_($matches[1]);
	return $translation;
}


/**
 * HTML Abstract View class for the Joomfish never used directly
 *
 * @since 2.0
 */
class JoomfishAbstractView extends JView
{
	 /**
	 * This method creates a standard cpanel button
	 *
	 * @param unknown_type $link
	 * @param unknown_type $image
	 * @param unknown_type $text
	 */
	 function _quickiconButton( $link, $image, $text, $path=null, $target='', $onclick='' ) {
	 	if( $target != '' ) {
	 		$target = 'target="' .$target. '"';
	 	}
	 	if( $onclick != '' ) {
	 		$onclick = 'onclick="' .$onclick. '"';
	 	}
	 	if( $path === null || $path === '' ) {
	 		$path = 'components/com_joomfish/assets/images/';
	 	}
		?>
		<div style="float:left;">
			<div class="icon">
				<a href="<?php echo $link; ?>" <?php echo $target;?>  <?php echo $onclick;?>>
					<?php echo JHTML::_('image.administrator', $image, $path, NULL, NULL, $text ); ?>
					<span><?php echo $text; ?></span>
				</a>
			</div>
		</div>
		<?php
	 }
	
	
	/**
	 * Method to determine the correct image path for language flags.
	 * The works as the standard JHTMLImage method except that it uses always the live site basic as URL
	 *
	 * @param unknown_type $language
	 * @param unknown_type $altFile
	 * @param unknown_type $altFolder
	 * @param unknown_type $alt
	 * @param unknown_type $attribs
	 * @return unknown
	 */
	function languageImage($language, $folder, $altFile=NULL, $altFolder='/images/M_images/', $alt=NULL, $attribs = null) {
		static $paths;
		global $mainframe;

		$file = '';
		if(!empty($language->image)) {
			//$file = 'flags/' . JFile::makeSafe(  $language->image);
			$file =  $language->image;
			$folder = "/images/";
		} elseif (!empty( $language->shortcode)) {
			$file = 'flags/' . $language->shortcode . '.gif';
		}

		if (!$paths) {
			$paths = array();
		}

		if (is_array( $attribs )) {
			$attribs = JArrayHelper::toString( $attribs );
		}

		$cur_template = $mainframe->getTemplate();

		if ( $altFile )
		{
			// $param allows for an alternative file to be used
			$src = $altFolder . $altFile;
		}
		else if ( $altFile == -1 )
		{
			// Comes from an image list param field with 'Do not use' selected
			return '';
		} else {
			$path = JPATH_SITE .'/templates/'. $cur_template .'/images/'. $file;
			if (!isset( $paths[$path] ))
			{
				if ( file_exists( JPATH_SITE .'/templates/'. $cur_template .'/images/'. $file ) ) {
					$paths[$path] = 'templates/'. $cur_template .'/images/'. $file;
				} else {
					// outputs only path to image
					$paths[$path] = $folder . $file;
				}
			}
			$src = $paths[$path];
		}

		if (substr($src, 0, 1 ) == "/") {
			$src = substr_replace($src, '', 0, 1);
		}

		return '<img src="'. JURI::root() . $src .'" alt="'. html_entity_decode( $alt ) .'" '.$attribs.' />';
	}
	
	/**
	 * Method to output the standard table footer
	 */
	function showTableFooter(){
		?>
	<tfoot>
		<tr>
			<td colspan="10">
			<div align="center"><span class="smallgrey">Joom!Fish Version <?php echo JoomFishManager::getVersionFooter();?>, &copy; 2003-2008 Copyright by <a href="http://www.ThinkNetwork.com" target="_blank" class="smallgrey">Think Network</a> under <a href="index2.php?option=com_joomfish&amp;task=showInformation&amp;fileCode=license" class="smallgrey">Open Source License.</a></span></div>
			</td>
		</tr>
	</tfoot>
		<?php
	}
	
	/**
	 * Method to use a tooltip independ from JElements
	 *
	 * @param string $label	title of the lable
	 * @param string $description	of the lable
	 * @param string $control_name	name of the control the lable is related to
	 * @param string $name	of the control
	 * @return unknown
	 */
	function fetchTooltip($label, $description, $control_name='', $name='')
	{
		$output = '<label id="'.$control_name.$name.'-lbl" for="'.$control_name.$name.'"';
		if ($description) {
			$output .= ' class="hasTip" title="'.JText::_($label).'::'.JText::_($description).'">';
		} else {
			$output .= '>';
		}
		$output .= JText::_( $label ).'</label>';

		return $output;
	}
	
	/**
	 * Routine to hide submenu suing CSS since there are no paramaters for doing so without hiding the main menu
	 *
	 */
	function _hideSubmenu(){
		// This won't work - since it leaves a little box in the template
		//$submenu = & JModuleHelper::getModule("submenu");
		//$submenu->content = " ";

		// This hides main menu too!!!
		//JRequest::setVar('hidemainmenu',1);		
		
		// Use CSS istead
	 	global $mainframe;
		$cssfile = '<link rel="stylesheet" href="' .$mainframe->getSiteURL(). '/administrator/components/com_joomfish/assets/css/hidesubmenu.css" type="text/css" />' . "\n";
		$mainframe->addCustomHeadTag( $cssfile );		
	 	
	}
	
	 function _JAdminHeading( $title, $title_class, $headingOptions = 'fish' ) {
	 	global $mainframe;
		$livesite = $mainframe->getSiteURL();
	 	if ( $headingOptions != '' ) {

	 		// title not used here in Joomla 1.5
  	?>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" >
		<tr>
			<th width="100%"  align="right" >
				<?php echo $headingOptions;?>
			</th>
		</tr>
	</table>
	<?php
	 	}
	 }
	
	 function _openAdminForm() {
  	?>
	<table width="90%" border="0" cellpadding="2" cellspacing="2" class="adminform" >
  	<?php
	 }

	 /**
	 * The page header generates a general output handling for all admin pages
	 *
	 */	function _pageHeader(){
		if( isset( $this->message) &&  $this->message != null ) {?>
		<div class="message"><?php echo $this->message;?></div>
		<?php
		}
	ob_start();
	 }
	

	 /**
	 * The page footer ensures a final translation of the content and outputs the page
	 *
	 */
	 function _pageFooter() {
	 	$content = ob_get_contents();
	 	ob_end_clean();
	 	// define the regular expression for the translation
	 	$regex = "|JText::_('(.*?)');?>|";
	 	$content = preg_replace_callback($regex,"jfTranslate",$content);
	 	echo $content;
	 }

	 function _JoomlaHeader( $title, $title_class='', $headingOptions= 'fish', $adminform = true ) {
	 	$this->_pageHeader();
	?>
	    <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
	    <div id="joomfish">
	    <form action="index2.php" method="post" name="adminForm">
	    <?php $this->_JAdminHeading( $title, $title_class, $headingOptions );?>
		<?php
		if ( $adminform ) {
			$this->_openAdminForm();
		}
	 }

	function _JoomlaFooter($task, $act, $editorFields=null) {
	 	global $mainframe;
		$livesite = $mainframe->getSiteURL();
		jimport( 'joomla.html.editor' );
		$wysiwygeditor =& JFactory::getEditor();
	?>
    </table>
    <input type="hidden" name="hidemainmenu" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="task" value="<?php echo $task; ?>" />
	<input type="hidden" name="act" value="<?php echo $act; ?>" />
	<input type="hidden" name="option" value="com_joomfish" />
    </form>
	<script  type="text/javascript" src="<?php echo $livesite;?>/includes/js/overlib_mini.js"></script>
    <script language="javascript" type="text/javascript">
    function submitbutton(pressbutton) {
    	var form = document.getElementsByName ('adminForm');
    	<?php
    	if( isset($editorFields) && is_array($editorFields) ) {
    		foreach ($editorFields as $editor) {
    			// Where editor[0] = your areaname and editor[1] = the field name
				echo $wysiwygeditor->save( $editor[1]);
    		}
    	}
    	?>
    	if (pressbutton == 'cancel') {
    		submitform( pressbutton );
    		return;
    	} else {
    		submitform( pressbutton );
    	}
    }
    </script>
    <table width="100%" border="0">
	<tr>
	  <td width="99%" align="right" valign="top">
		<?php
		$x = "@";
		$y="Support";
		$z="JoomFish.net";
		$mail=$y.$x.$z;
		?><div align="center"><span class="smallgrey">Joom!Fish Version <?php echo JoomFishManager::getVersionFooter();?>, &copy; 2003-2008 Copyright by <a href="http://www.ThinkNetwork.com" target="_blank" class="smallgrey">Think Network</a> under <a href="index2.php?option=com_joomfish&amp;task=showInformation&amp;fileCode=license" class="smallgrey">Open Source License.</a> Contact: <?php echo JHTML::_('email.cloak', $mail, 0);?></span></div>
	  </td>
	  </tr>
	</table>
	</div>
	<?php
	$this->_pageFooter();
	 }
	 
	/**
	 * Show the side menu
	 *
	 */
	function _sideMenu() {
  	?>
		<img src="<?php echo JURI::root();?>administrator/components/com_joomfish/assets/images/joomfish_slogan.png" border="0" alt="<?php echo JText::_('Language Title');?>"  />
		<p><span class="contentheading"><?php echo JText::_('Related topics');?>:</span>
		<ul>
			<li><a href="http://www.joomfish.net" target="_blank"><?php echo JText::_('Official Project WebSite');?></a></li>
			<li><a href="http://www.joomfish.net/forum/" target="_blank"><?php echo JText::_('Official Project Forum');?></a></li>
			<li><a href="http://joomlacode.org/gf/project/joomfish/tracker/" target="_blank"><?php echo JText::_('Bug and Feature tracker');?></a></li>
		</ul>
		</p>
		<p><span class="contentheading"><?php echo JText::_('Documentation and Tutorials');?>:</span>
		<ul>
			<li><a href="http://www.joomfish.net/joomfish-documentation-overview.html" target="_blank"><?php echo JText::_('Online Documentation and Tutorials');?></a></li>
			<li><a href="index2.php?option=com_joomfish&amp;task=postInstall"><?php echo JText::_('Installation notes');?></a></li>
			<li><a href="index2.php?option=com_joomfish&amp;task=showInformation&amp;fileCode=changelog"><?php echo JText::_('Changelog');?></a></li>
		</ul>
		</p>
		<p><span class="contentheading"><?php echo JText::_('License');?>:</span>
		<ul>
			<li><a href="index2.php?option=com_joomfish&amp;task=showInformation&amp;fileCode=license">GPL based Think Network Open Source license</a></li>
		</ul>
		</p>
		<p><span class="contentheading"><?php echo JText::_('Additional Sites');?>:</span>
		<ul>
			<li><a href="http://www.joomla.org" target="_blank">Joomla!</a></li>
		</ul>
		</p>
  	<?php
	}
	
	function _creditsCopyright() {
		?>
		<p>
		<span class="smallgrey"><strong>Credits:</strong></span><br />
		<span class="smallgrey">To all the people of the JoomFish community!<br />
		Present development team:
		<ul>
			<li>Alex Kempkens (<?php
			$x = "@";
			$y="Alex";
			$z="JoomFish.net";
			$mail=$y.$x.$z;

			echo JHTML::_('email.cloak', $mail, 0);
			?>)</li>
			<li>Geraint Edwards (<?php
			$x = "@";
			$y="joomfish.credits";
			$z="copyn.plus.com";
			$mail=$y.$x.$z;

			echo JHTML::_('email.cloak', $mail, 0);
			?>)</li>
			<li>Ivo Apostolov (<?php
			$x = "@";
			$y="ivo";
			$z="joomfish.net";
			$mail=$y.$x.$z;

			echo JHTML::_('email.cloak', $mail, 0);
			?>)</li>
			<li>Robin Muilwijk</li>
		</ul>
		<br />

		Logo design by:
		<ul>
			<li>Tommy White (<?php
			$x = "@";
			$y="tommy";
			$z="tommywhite.com";
			$mail=$y.$x.$z;

			echo JHTML::_('email.cloak', $mail, 0);
			?>)</li>
		</ul>

		&nbsp;<br />
		Special thank's for testing, good suggestions & translations to:<br />
		Bernhard, Michael, Luc, Olivier, Robin, Rune, Victor, Akarawuth</span><br />

		&nbsp;<br />
		<span class="smallgrey"><strong>Contact:</strong></span><br />
		<?php
		$x = "@";
		$y="Support";
		$z="JoomFish.net";
		$mail=$y.$x.$z;

		echo '<span class="smallgrey">' .JHTML::_('email.cloak', $mail, 1) .'</span>';
		?>
		<br />
		&nbsp;<br />
		<span class="smallgrey"><strong>Version:</strong></span><br />
		<span class="smallgrey"><?php echo JoomFishManager::getVersion();?></span><br />
		&nbsp;<br />
		<span class="smallgrey"><strong>Copyright:</strong></span><br />
		<span class="smallgrey">&copy; 2003-2008 </span><a href="http://www.ThinkNetwork.com" target="_blank" class="smallgrey"><span class="smallgrey">Think Network, Munich</span></a><br />
		<a href="index2.php?option=com_joomfish&amp;task=showInformation&amp;fileCode=license" class="smallgrey"><span class="smallgrey">Open Source License.</span></a>
		</p>
		<?php
	}
}