<?php
/**
 * @version     $Id$ 2.0.0 0
 * @package     Joomla
 * @copyright   Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license     GNU/GPL, see LICENSE.php
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// define the default aiContactSafe controller class
class AiContactSafeControllerMessage extends AiContactSafeController {

	// default function to call when a task is not specified
	function display() {
		$model = &$this->getModel( $this->_sTaskModel, '', $this->_parameters );
		$ban_ip = $model->checkBanIp();
		if ( $ban_ip ) {
			$link = $this->_config_values['redirect_ips'];
			if (strlen(trim($link)) == 0) {
				$link = JURI::base();
			}
			$this->setRedirect($link);
		} else {
			$send_mail = JRequest::getVar( 'send_mail', 0, 'post', 'int');
			if ($send_mail == 1) {
				$isOK = $model->getFormFields();
				if ($isOK) {
					$isOK = $model->SendEmail();
				}
				if ($isOK) {
					$link = $model->getReturnLink();
					$msg = $this->_app->getUserState( 'confirmationMessage:' . $this->_sTask );
					$msgType = 'message';
				} else {
					$link = $model->getLastLink();
					$msg = $this->_app->getUserState( 'errorMsg:' . $this->_sTask );
					$msgType = 'error';
				}
				$this->setRedirect($link, $msg, $msgType);
			} elseif ($send_mail == 2) {
				$link = $model->getReturnLink();
				$this->setRedirect($link);
			} else {
				// read the fields sent when the contact form was called
				$dt = JRequest::getVar('dt', 0, 'post', 'int');
				if ( $dt ) {
					$model->getFormFields();
				}
				// generate the view
				$view = &$this->getView( $this->_sTaskView, 'html', '', $this->_parameters );
				$view->setModel( $model, true );
				$view->setLayout( $this->_sTaskLayout );
				$view->viewDefault();
			}
		}
	}

	// function to record the last task in a temporary variable
	function recordLastTask() {
		// dissable the function to record the last task for captcha
	}

	// function to controll the task 'download'
	function download() {
		// get the current model and start the download
		$model = &$this->getModel( $this->_sTaskModel, '', $this->_parameters );
		$model->downloadFile();
	}
}

?>
