<?php
/**
* @version		$Id: view.html.php 939 2008-04-01 18:15:59Z geraint $
* @package		Joomla
* @subpackage	Weblinks
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

JLoader::import( 'views.abstract.joomfishview',JPATH_COMPONENT_ADMINISTRATOR);

/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
class TranslateViewTranslate extends JoomfishAbstractView
{
	/**
	 * Control Panel display function
	 *
	 * @param template $tpl
	 */
	function display($tpl = null)
	{
		$document =& JFactory::getDocument();
		// this already includes administrator
		$livesite = JURI::base();
		$document->addStyleSheet($livesite.'components/com_joomfish/assets/css/joomfish.css');

		$layout = $this->getLayout();
		if (method_exists($this,$layout)){
			return $this->$layout($tpl);
		}
			
		// browser title
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('TITLE_TRANSLATION'));
		
		// Set  page title
		JToolBarHelper::title( JText::_( 'TITLE_TRANSLATION' ), 'jftranslations' );

		// Set toolbar items for the page
		JToolBarHelper::help( 'screen.translation', true);

		JSubMenuHelper::addEntry(JText::_('Control Panel'), 'index2.php?option=com_joomfish', true);
		JSubMenuHelper::addEntry(JText::_('Translation'), 'index2.php?option=com_joomfish&amp;task=translate.overview');
		JSubMenuHelper::addEntry(JText::_('Orphans'), 'index2.php?option=com_joomfish&amp;task=translate.orphans');
		JSubMenuHelper::addEntry(JText::_('Manage Translations'), 'index2.php?option=com_joomfish&amp;task=manage.overview');
		JSubMenuHelper::addEntry(JText::_('Help and Credits'), 'index2.php?option=com_joomfish&amp;task=help.credits');
			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}
	
	
	function overview($tpl = null)
	{
		// browser title
		$document =& JFactory::getDocument();
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('TRANSLATE'));
		
		// set page title
		JToolBarHelper::title( JText::_( 'TRANSLATE' ), 'translation' );

		// Set toolbar items for the page
		JToolBarHelper::publish("translate.publish");
		JToolBarHelper::unpublish("translate.unpublish");
		JToolBarHelper::editList("translate.edit");
		JToolBarHelper::deleteList(JText::_("ARE YOU SURE YOU WANT TO DELETE THIS TRANSLATION"), "translate.remove");
		JToolBarHelper::custom( 'cpanel.show', 'joomfish', 'joomfish', JText::_( 'CONTROL PANEL' ), false );
		JToolBarHelper::help( 'translate.overview', true);

		// hide the sub menu
		$this->_hideSubmenu();
			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	
	
	function edit($tpl = null)
	{
		// browser title
		$document =& JFactory::getDocument();
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('Translate'));
		
		// set page title
		JToolBarHelper::title( JText::_( 'Translate' ), 'translation' );

		// Set toolbar items for the page
		echo JRequest::getVar("catid","xxx");
		if (JRequest::getVar("catid","")=="content"){
			//JToolBarHelper::preview('index.php?option=com_joomfish',true);
			$bar = & JToolBar::getInstance('toolbar');
			// Add a special preview button by hand			
			$live_site = JURI::base();			
			$bar->appendButton( 'Popup', 'preview', 'Preview', JRoute::_("index3.php?option=com_joomfish&task=translate.preview"), "800","550");
		}
		JToolBarHelper::save("translate.save");
		JToolBarHelper::cancel("translate.overview");

			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	

	function orphans($tpl = null)
	{
		// browser title
		$document =& JFactory::getDocument();
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('CLEANUP ORPHANS'));
		
		// set page title
		JToolBarHelper::title( JText::_( 'CLEANUP ORPHANS' ), 'orphan' );

		// Set toolbar items for the page
		JToolBarHelper::deleteList(JText::_("ARE YOU SURE YOU WANT TO DELETE THIS TRANSLATION"), "translate.removeorphan");
		JToolBarHelper::custom( 'cpanel.show', 'joomfish', 'joomfish', JText::_( 'CONTROL PANEL' ), false );
		JToolBarHelper::help( 'translate.orphans', true);

		// hide the sub menu
		$this->_hideSubmenu();
			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	

	function orphandetail($tpl = null)
	{
		// browser title
		$document =& JFactory::getDocument();
		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('CLEANUP ORPHANS'));
		
		// set page title
		JToolBarHelper::title( JText::_( 'CLEANUP ORPHANS' ), 'orphan' );

		// Set toolbar items for the page
		//JToolBarHelper::deleteList(JText::_("ARE YOU SURE YOU WANT TO DELETE THIS TRANSLATION"), "translate.removeorphan");
		JToolBarHelper::back();
		JToolBarHelper::custom( 'cpanel.show', 'joomfish', 'joomfish', JText::_( 'CONTROL PANEL' ), false );
		JToolBarHelper::help( 'translate.orphans', true);

		// hide the sub menu
		// This won't work
		$submenu = & JModuleHelper::getModule("submenu");
		$submenu->content = "\n";
		
		//JRequest::setVar('hidemainmenu',1);		
			
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}	

	function preview($tpl = null)
	{
		// hide the sub menu
		$this->_hideSubmenu();
		parent::display($tpl);
		
	}
}
