<?php
/**
* @version		$Id: view.html.php 928 2008-03-30 10:51:32Z akede $
* @package		Joomla
* @subpackage	Weblinks
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view');
jimport('joomla.html.pane');

/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
class PluginViewPlugin extends JView
{
	/**
	 * Control Panel display function
	 *
	 * @param template $tpl
	 */
	function display($tpl = null)
	{
		global $mainframe;
		
		$document =& JFactory::getDocument();
		// this already includes administrator
		$livesite = JURI::base();
		$document->addStyleSheet($livesite.'components/com_joomfish/assets/css/joomfish.css');

		$document->setTitle(JText::_('JOOMFISH_TITLE') . ' :: ' .JText::_('CONTROL PANEL'));
		
		// Set toolbar items for the page
		JToolBarHelper::title( JText::_('JOOMFISH_TITLE') .' :: '. JText::_( 'JOOMFISH_HEADER' ), 'fish' );
		JToolBarHelper::preferences('com_joomfish', '360');
		JToolBarHelper::help( 'screen.cpanel', true);

		JSubMenuHelper::addEntry(JText::_('Control Panel'), 'index2.php?option=com_joomfish', true);
		JSubMenuHelper::addEntry(JText::_('Translation'), 'index2.php?option=com_joomfish&amp;task=translate.overview');
		JSubMenuHelper::addEntry(JText::_('Orphans'), 'index2.php?option=com_joomfish&amp;task=manage.orphans');
		JSubMenuHelper::addEntry(JText::_('Manage Translations'), 'index2.php?option=com_joomfish&amp;task=manage.overview');
		JSubMenuHelper::addEntry(JText::_('Help and Credits'), 'index2.php?option=com_joomfish&amp;task=help.credits');
		
		$panelStates	= &$this->get('PanelStates');
		$contentInfo	= &$this->get('ContentInfo');
		$publishedTabs	= &$this->get('PublishedTabs');
		
		$this->assignRef('panelStates', $panelStates);
		$this->assignRef('contentInfo', $contentInfo);
		$this->assignRef('publishedTabs', $publishedTabs);
		
		JHTML::_('behavior.tooltip');
		parent::display($tpl);
	}
	
	 /**
	 * This method creates a standard cpanel button
	 *
	 * @param unknown_type $link
	 * @param unknown_type $image
	 * @param unknown_type $text
	 */
	 function _quickiconButton( $link, $image, $text, $path=null, $target='', $onclick='' ) {
	 	if( $target != '' ) {
	 		$target = 'target="' .$target. '"';
	 	}
	 	if( $onclick != '' ) {
	 		$onclick = 'onclick="' .$onclick. '"';
	 	}
	 	if( $path === null || $path === '' ) {
	 		$path = 'components/com_joomfish/assets/images/';
	 	}
		?>
		<div style="float:left;">
			<div class="icon">
				<a href="<?php echo $link; ?>" <?php echo $target;?>  <?php echo $onclick;?>>
					<?php echo JHTML::_('image.administrator', $image, $path, NULL, NULL, $text ); ?>
					<span><?php echo $text; ?></span>
				</a>
			</div>
		</div>
		<?php
	 }

	 /**
	  * render Information module
	  */
	 function renderInformation () {
	 	$output = '';
	 	$panelStates = $this->get('panelStates');
		$sysInfo =  $panelStates['system'];
		
		$output .= '<p>' .JText::printf('INFORMATION_TEXT', $sysInfo['translations']) .'</p>';
		$output .= '<p>' .JText::_('INFORMATION_SHOP'). '</p>';
		$output .= '<p>' .JText::printf ('INFORMATION_DONATE', intval($sysInfo['translations']) *0.10). '<br />';
		$output .= '<div align="center">';
		$output .= '<iframe src="/administrator'.JOOMFISH_URL.'/donate.php?translations=' .intval($sysInfo['translations']). '" frameborder="0" style="border:0px;height:80px;width:180px;overflow:hidden;"></iframe>';
		$output .= '</p>';
		
		return $output;
	 }
	 
	 /**
	  * render News feed from Joom!Fish portal
	  */
	 function renderJFNews() {
	 	$output = '';
	 	return $output;
	 }
	 
	 /**
	  * render content state information
	  */
	 function renderContentState() {
	 	$output = '';
	 	return $output;
	 }
	 
	 /**
	  * render system state information
	  */
	 function renderSystemState() {
	 	$output = '';
	 	return $output;
	 }
	 
	/**
	 * Creates the CPanel for the Joom!Fish component
	 * @param array	status informations for the panel
	 */
	function showCPanel( $panelStates, $contentInfo ) {
		global $act, $task, $option, $joomFishManager;
		$live_site = JURI::base();			
		HTML_joomfish::_header()
		?>
		<tr>
			<td width="55%" valign="top">
				<div id="cpanel">
				<?php
				$link = 'index2.php?option=com_joomfish&amp;task=translate.overview';
				HTML_joomfish::_quickiconButton( $link, 'addedit.png', JText::_('Translation') );

				$link = 'index2.php?option=com_joomfish&amp;task=manage.orphans';
				HTML_joomfish::_quickiconButton( $link, 'query.png', JText::_('Orphans') );

				$link = 'index2.php?option=com_joomfish&amp;task=manage.overview';
				HTML_joomfish::_quickiconButton( $link, 'menu.png', JText::_('Manage Translations') );

				$link = 'index2.php?option=com_joomfish&amp;task=help.show';
				HTML_joomfish::_quickiconButton( $link, 'support.png', JText::_('HELP AND HOWTO') );

				echo '<div style="clear: both;" />';

				$link = 'index2.php?option=com_joomfish&amp;task=language.show&amp;hidemainmenu=1';
				HTML_joomfish::_quickiconButton( $link, 'langmanager.png', JText::_('Language Configuration') );

				$link = 'index2.php?option=com_joomfish&amp;task=elements.show';
				HTML_joomfish::_quickiconButton( $link, 'cpanel.png', JText::_('Content elements') );

				$link = 'index2.php?option=com_joomfish&amp;task=help.credits';
				HTML_joomfish::_quickiconButton( $link, 'credits.png', JText::_('Help and Credits') );

				?>
			</div>
			</td>
			<td width="45%" valign="top">
				<div style="width: 100%;">
					<?php

					// Prepare formating for the output of the state
					$stateRows = array();
					$alertState = false;
					$alertContent = false;
					foreach ($panelStates as $key => $state ) {
						if( ereg( '_state', $key ) ) {
							if( !$state ) {
								$alertState = true;
							}
							$stateHeader = substr($key, 0, strpos($key, '_'));
							$stateGroups[$stateHeader] = $panelStates[$stateHeader];
						} elseif ( ereg( 'mbf', $key )) {
							if( $state == 2 ) {
								$panelStates [ $key . '_href' ] = "";
								$panelStates[ $key . '_text' ] = JText::_('INSTAL_UPGRADED');
							} elseif($state == 1) {
								$panelStates[ $key . '_href' ] = "$live_site/administrator/index2.php?option=com_joomfish&amp;task=show&amp;act=upgrade_install&amp;hidemainmenu=1";
								$panelStates[ $key . '_text' ] = JText::_('INSTAL_NOT_UPGRADED');
								$alertState = true;
							}
						}

					}

					if( array_key_exists('unpublished', $contentInfo) && is_array($contentInfo['unpublished']) ) {
						$alertContent = true;
					}

					$publishedTabs = $joomFishManager->getCfg('showCPanels');

					// Tabs
					jimport('joomla.html.pane');
					$tabs = & JPane::getInstance('tabs');
					echo $tabs->startPane( 'modules-jfcpane' );

					echo $tabs->startPanel( JText::_('Information'), 'jfinformation' );
					$sysInfo =  $panelStates['system'];
					?>
					<table class="adminlist" border="1">
						<tr><th><?php echo JText::_('JOOMFISH_TITLE');?></th></tr>
						<tr><td><?php JText::printf('INFORMATION_TEXT', $sysInfo['translations']);?></tr>
						<tr><td><?php echo JText::_('INFORMATION_SHOP');?></td></tr>
						<tr><td><p><?php JText::printf ('INFORMATION_DONATE', intval($sysInfo['translations']) *0.10);?></p>
						<div align="center">
							<iframe src="<?php echo JPATH_SITE;?>/administrator/components/com_joomfish/donate.php?translations=<?php echo intval($sysInfo['translations']);?>" frameborder="0" style='border:0px;height:80px;width:180px;overflow:hidden;'></iframe>
						</div>
						</td></tr>
					</table>
					<?php
					echo $tabs->endPanel();

					/*
					* Disabled until we replace domit
					*/
					/*
					if( $publishedTabs & JFCPANEL_NEWS ) {
						$tabs->startPanel( JText::_('News'), 'jfnews' );
						require_once(JPATH_SITE . "/includes/domit/xml_domit_rss_lite.php");

					    $cacheDir = JPATH_SITE . "/cache/";
					    $LitePath = JPATH_SITE . "/includes/Cache/Lite.php";
					    @$rss = &new xml_domit_rss_document_lite();
					    $rss->useCacheLite(true, $LitePath, $cacheDir, 86400 );
					    $rss->loadRSS('http://www.joomfish.net/rss-feed/extension-news/');
						?>
						<table class="adminlist">
							<?php
							if( $rss->getChannelCount() == 0 ) {
								?>
							<tr>
								<th colspan="3"><?php echo JText::_('Joom!Fish news');?></th>
							</tr>
							<tr>
								<td colspan="3"><?php echo JText::_('NEWS_INTRODUCTION');?></td>
							</tr>
							<?php
							} else {
								$k=0;
								$channel = &$rss->getChannel(0);
								?>
							<tr>
								<th colspan="3"><a href="<?php echo $channel->getLink() ?>" target="_blank"><?php echo $channel->getTitle()?></a></th>
							</tr>
							<tr>
								<td colspan="3"><?php echo JText::_('NEWS_INTRODUCTION');?></td>
							</tr>
								<?php
					            $numItems = $channel->getItemCount();
					            if( !$numItems ) {
					            	?>
					                <tr><th><?php echo JText::_('No news items found');?></th></tr><?php
					            } else {
					            	$numItems = ($numItems > 5) ? 5 : $numItems;
					                for( $j = 0; $j < $numItems; $j++ ) {
					                    $item = & $channel->getItem($j);?>
					                	<tr><td class="row<?php echo $k;?>">
					                        <a href="<?php echo $item->getLink()?>" target="_blank"><?php echo $item->getTitle()?></a><?php
					                        if( $description = HTML_joomfish::_truncateString($item->getDescription(), 500) ) {?>
					                            <br /><?php echo $description?><?php
					                        }?>
					                    </td></tr><?php
					                }
					            }
								$k = 1 - $k;
							}
							?>
						</table>
						<?php
						$tabs->endPanel();
					}
					*/

					if( $publishedTabs & JFCPANEL_UNPUBLISHED || $alertContent ) {
					$tabTitle = $alertContent==true ? '<span style="color: red; font-weight: bold;">' .JText::_('TITLE_UNPUBLISHED'). '</span>' : JText::_('TITLE_UNPUBLISHED');
					echo $tabs->startPanel( $tabTitle, 'jfcontentstate' );
					?>
					<table class="adminlist" border="1">
						<tr>
							<th><?php echo JText::_('UNPUBLISHED CONTENT ELEMENTS');?></th>
							<th style="text-align: center;"><?php echo JText::_('Language');?></th>
							<th style="text-align: center;"><?php echo JText::_('Publish');?></th>
						</tr>
						<?php
						$k=0;
						if( $alertContent ) {
							$curReftable = '';
							foreach ($contentInfo['unpublished'] as $ceInfo ) {
									$contentElement = $joomFishManager->getContentElement( $ceInfo['catid'] );

								if ($ceInfo["reference_table"] != $curReftable){
									$curReftable = $ceInfo["reference_table"];
									$k=0;
									?>
						<tr><td colspan="3"><strong><?php echo $contentElement->Name;?></strong></td></tr>
									<?php
								}

								$contentObject = new ContentObject( $ceInfo['language_id'], $contentElement );
								$contentObject->loadFromContentID($ceInfo['reference_id']);
								$link = 'index2.php?option=com_joomfish&amp;task=edit&amp;&amp;act=translate&amp;&amp;catid=' .$ceInfo['catid']. '&cid[]=0|' .$ceInfo['reference_id'].'|'.$ceInfo['language_id'];
								$hrefEdit = "<a href='".$link."'>".$contentObject->title. "</a>";

								$link = 'index2.php?option=com_joomfish&amp;task=publish&amp;&amp;act=translate&amp;&amp;catid=' .$ceInfo['catid']. '&cid[]=0|' .$ceInfo['reference_id'].'|'.$ceInfo['language_id'];
								$hrefPublish = '<a href="'.$link.'"><img src="images/publish_x.png" width="12" height="12" border="0" alt="" /></a>';
								?>
						<tr class="row<?php echo $k;?>">
							<td align="left"><?php echo $hrefEdit;?></td>
							<td style="text-align: center;"><?php echo $ceInfo['language'];?></td>
      						<td style="text-align: center;"><?php echo $hrefPublish;?></td>
						</tr>
								<?php
								$k = 1 - $k;
							}
						} else {
								?>
						<tr class="row0">
							<td colspan="3"><?php echo JText::_('No unpublished translations found');?></td>
						</tr>
								<?php
						}
						?>
					</table>
					<?php
					echo $tabs->endPanel();
					}
					
					if( $publishedTabs & JFCPANEL_STATE || $alertState ) {
					$tabTitle = $alertState==true ? '<span style="color: red; font-weight: bold;">' .JText::_('System State'). '</span>' : JText::_('System State');
					echo $tabs->startPanel( $tabTitle, 'jfsystemstate' );
					?>
					<table class="adminlist">
						<?php
						foreach ($stateGroups as $key=>$stateRow) {
							?>
						<tr>
							<th colspan="3"><?php echo JText::_('<?php echo $key. ' state';?>');?></th>
						</tr>
							<?php
							$k=0;
							foreach ($stateRow as $row) {
								?>
						<tr class="row<?php echo $k;?>">
							<td><?php
							if( $row->link != '' ) {
								$row->description = '<a href="' .$row->link. '">' .$row->description. '</a>';
							}
							echo $row->description;
							?></td>
								<td colspan="2"><?php echo $row->resultText;?></td>
								<?php
								$k = 1 - $k;
							}
						}
						?>

						<?php if( key_exists( 'mbfInstall', $panelStates ) && $panelStates['mbfInstall'] != 0 ) { ?>
						<tr>
							<th colspan="3"><?php echo JText::_('Translation State');?></th>
						</tr>
						<tr class="row">
							<td><?php echo JText::_('Mambelfish Install');?></td>
							<td><?php echo $panelStates['mbfInstall_text' ];?></td>
								<td><?php if( $panelStates[ 'mbfInstall_href' ] != "" ) : ?>
								<a href="<?php echo $panelStates[ 'mbfInstall_href' ];?>"><img src="<?php echo $live_site;?>/administrator/images/dbrestore.png" border="0" alt="<?php echo JText::_('UPGRADE_INSTALLATION');?>" /></a>
								<?php endif; ?>
								</td>
						</tr>
						<?php } ?>
					</table>
					<?php
					echo $tabs->endPanel();
					}

					echo $tabs->endPane();
					?>
				</div>
			</td>
		</tr>
		<?php
		HTML_joomfish::_JoomlaFooter( '', $act, $option );
	}
}